// <language>JScript</language>

// (c) 2004 Gunnar Beutner

/***
 | core
 ***/

var SettingsHash;
var ircColor = '\3';

AddHandlerPrefix("sicore_");

function sicore_OnInit() {
	try {
		SettingsHash = Hashtables("shroudsettings");
	} catch (e) {
		SettingsHash = CreateHashtable("shroudsettings");
		try {
			SettingsHash.Load("settings.hash");
		} catch (e) { }
	}
}

function shroudget(item) {
	try {
		return SettingsHash(item);
	} catch (e) { return ""; }
}

function shroudset(item, value) {
	SettingsHash(item) = value;
	SettingsHash.Save("settings.hash");
}

function shroudsetUser(p) {
	return shroudset(Arg(p, 1), Arg(p, 2, true));
}

function hdump(hash) {
	ActiveWindow.LineSep();

	if (hash == undefined) {
		var en = new Enumerator(Hashtables);
		
		for (; !en.atEnd(); en.moveNext()) {
			var item = en.item();
			ActiveWindow.Echo(item.Name);
		}
	} else {
		try {
			var en = new Enumerator(Hashtables(hash));
			
			for (; !en.atEnd(); en.moveNext()) {
			var item = en.item();
				ActiveWindow.Echo(item.Key + " -> " + item.Value);
			}		
		} catch(e) {
			ActiveWindow.Echo("invalid index '" + hash + "'");
		}
	}
}

function Think(arg) {
	if (arg == undefined) { return; }
	else { ActiveWindow.Message(".oO( " + arg + ")"); }
}

function ModeX(arg) {
	Mode(Self, "arg");
}

function Deaf(dummy) {
	ModeX("+d");
}

function UnDeaf(dummy) {
	ModeX("-d");
}

function Illuminati(text) {
	try {
		ActiveWindow.Message(ircColor + "4,1" + Arg(text, 1) + ircColor + "0 " + Arg(text, 2, true));
	} catch (e) { }
}

function UpdateChannelInfo(arg) {
	try {
		Channels(ActiveWindow).Names();
	} catch (e) { /* invalid window */ }
}

function WA_Function(arg) {
	DllCall("wa_link.dll", "WA_Link_Command", arg);
}

function WA_Pause(dummy) {
	WA_Function("pause");
}

function WA_Previous(dummy) {
	WA_Function("prev");
}

function WA_Next(dummy) {
	WA_Function("next");
}

function Kid(dummy) {
	// #poff legacy :/
	Think("die kiddies sind wieder da, die es ausnahmsweise geschafft haben, das modem anzuschalten und ein passwort einzugeben");
}

// TODO: fix bug
function Slap(nick) {
	if (nick == undefined) { return; }
	else { ActiveWindow.Describe(Evaluate("$read(data\slap.txt)")); }
}

function IsNet(net) {
	if (net == undefined) { return false; }

	if (Server.substr(Server.length - net.length) == net) { return true; }
	else { return false; }
}

function QWhois(nick) {
	if (nick == undefined || !IsNet(".quakenet.org")) { return; }
	else { Message("Q", "whois " + nick); }
}

function LWhois(nick) {
	if (nick == undefined || !IsNet(".quakenet.org")) { return; }
	else { Message("L", "whois " + nick); }
}

function DMp3(file) {
	ActiveWindow.Echo("Download of media file " + NoPath(file) + " finished. Press Shift+F3 to play this file with WinAMP.");
	Run(DllCall("wa_link.dll", "wa_link_raw_stats", "wadir") + "winamp.exe /add \"" + file + "\"");
}

function ComChan(nick) {
	if (nick == undefined) { return; }

	var en = new Enumerator(GetNick(nick).ComChans);
	var chans = "";

	for (; !en.atEnd(); en.moveNext()) {
		var chan = en.item().Name;
		
		if (chans.length && !en.atEnd())
			chans += ", ";

		if (chans != undefined) // next statement would result in "undefined#channel" without the if
			chans += chan;
		else
			chans = chan;
	}

	if (chans == undefined)
		ActiveWindow.Describe("doesn't have any channels in common with " + nick);
	else
		ActiveWindow.Describe("has the following channel" + IIf(chans.indexOf(' ') != -1, "s", "") + " in common with " + nick + ": " + chans);
}